# Reactive Programing: event streams

## Outline

### Objective

* Setup a firebase app
* Deploy the app manually
* Deploy the app with travis ci and github

### Technologies used

* Javascript
* Firebase

### Design Patterns

* Continious Deployment
* Real time database

### What we will do

* View Firebase video or read documentation
* Setup out app and connect to it
* Show how it is used in our ToDo app
* Deploy the app using firebase-tools
* Setup gitlab to deploy the app for us every time we push
* Re-Implement our Simple Messenger Using this app

## Pre Session

- [Read the web documentation](https://firebase.google.com/docs/web/setup)

The areas relevant for our tutorial areas

- Getting Started
- Realtime database
- Hosting
- Authentication

Watch the following videos

- [Firebase for those coming from SQL](https://www.youtube.com/watch?v=rtoxRg-kbt0&list=PLl-K7zZEsYLlP-k-RKFa7RyNPa9_wCH2s)
- [React + Firebase](https://www.youtube.com/watch?v=mwNATxfUsgI&index=12&list=PLl-K7zZEsYLmnJ_FpMOZgyg6XcIGBu2OX)
- [React + Firebase 2](https://www.youtube.com/watch?v=p4XTMvagQ2Q&index=11&list=PLl-K7zZEsYLmnJ_FpMOZgyg6XcIGBu2OX)
- [Deploy with github](https://www.youtube.com/watch?v=QLVzozWDYAs&list=PLl-K7zZEsYLmnJ_FpMOZgyg6XcIGBu2OX&index=10)

## Session


Take our starting messenger app and make it use Firebase realtime database
Build and Deploy the messenger for all people to see and use

Update your simple messenger from the assignments to use Firebase


### Rubric

- Setup simple messenger provided to use firebase (2 points)
- Setup messenger with all features from your last assignment (6 points)
- Build and Deploy front end app 2 points

> All Assignments are due by max Thursday to be extended to Monday the 8th of May

## Bonus

(2  points) Setup gitlab or github + travis CI as in the video to automatically deploy on push

(18 points) Implement the messenger [app represented in this coggle instead of the simple session messenger](https://coggle.it/diagram/WQLibnM_5QABjThe)
  - no need to Implement the session's simple messenger all points are aded to this assignment
  - Rubric
    - React app (10 points)
      - app views
      - structuring the project as indicated
      - properly subscribing and updating state in life cycle hooks from firebase
    - Firebase (4 points)
      - (1) Structuring database
      - (1) Querying realtime database      
      - (1) Hosting
      - (1) Security and Rules
    - react-router (2 points)
    - Facebook auth (2 points)
